import numpy as np
import torch
import torch.nn as nn
import torch.nn.functional as F
from utils_data import *
from models import *
import scipy

device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")

 
def SC_Conf_loss(output, weight):
    output = output.to(device)
    weight = weight.to(device)
    log_soft = -torch.log_softmax(output, dim=-1).to(device)
    final_loss = torch.mean(torch.sum(torch.mul(weight, log_soft).to(device), dim=-1).to(device)).to(device)
    return final_loss

def accuracy_check(loader, model):
    num_samples = torch.zeros(1).to(device)
    total = torch.zeros(1).to(device)
    for i, (images, labels) in enumerate(loader):
        labels, images = labels.to(device), images.to(device)
        outputs = model(images).detach().to(device)
        softmax_outputs = torch.softmax(outputs, dim=-1).to(device)
        t1 = torch.max(softmax_outputs, -1)[1].to(device)
        total += torch.sum(t1 == labels).to(device)
        num_samples += labels.size(0)
    acc = total / num_samples
    acc = acc[0]
    return acc*100
